#include "BulletWorld.h"

#include "BtDebugDraw.h"


//RXgN^
//yFȂz
CBulletWorld::CBulletWorld(void):
_pColConfig(NULL), _pDispatcher(NULL), _pOverlappingPairCache(NULL), _pSolver(NULL), _pDynamicsWorld(NULL),
_pDebugDraw(NULL)
{
	return;
}



//fXgN^
//yF--z
CBulletWorld::~CBulletWorld(void)
{
	return;
}



//[h̍쐬
//y߂lFȂzyFfobO\Ɏg`pfoCXz
void CBulletWorld::CreateWorld(LPDIRECT3DDEVICE9 pD3DDevice)
{
	//ftHg̏ՓˌmASY
	_pColConfig = new btDefaultCollisionConfiguration( );

	//ftHg̏Փ˃fBXpb`
	_pDispatcher = new btCollisionDispatcher(_pColConfig);

	//KwIȏՓˌmASY
	_pOverlappingPairCache = new btDbvtBroadphase( );

	//V[PV()ȃCpX@
	_pSolver = new btSequentialImpulseConstraintSolver;

	//[h̃CX^X𐶐
	_pDynamicsWorld = new btDiscreteDynamicsWorld(_pDispatcher, _pOverlappingPairCache, _pSolver, _pColConfig);

	//[h̏d͉xݒ
	_pDynamicsWorld->setGravity(btVector3(0.0f, -9.80665f, 0.0f) * 3);

	//fobO`NXɎ̂
	_pDebugDraw = new CBtDebugDraw(pD3DDevice);
	//[hɃZbgāAC[t[Ȃǂ̃fobO`ł悤ɂ
	_pDynamicsWorld->setDebugDrawer(_pDebugDraw);


	return;
}



//[h̉
//y߂lFȂzyFȂz
void CBulletWorld::ReleaseWorld(void)
{
	//fobO`NX̃CX^X폜
	delete _pDebugDraw;

	//[h폜
	delete _pDynamicsWorld;

	//\o[폜
	delete _pSolver;

	//Փˌm̃u[htFCY폜
	delete _pOverlappingPairCache;

	//fBXpb`폜
	delete _pDispatcher;

	//ՓˌmASY폜
	delete _pColConfig;


	return;
}



//^CC^[o̐ݒ
//y߂lFȂzyF1[vŐi߂l, 3̃t[𒴂ꍇɍőŐi߂Xebv, vZł̂Pt[̒(b)z
void CBulletWorld::StepSimulation(btScalar timeStep, int maxSubSteps, btScalar fixedTimeStep)
{
	_pDynamicsWorld->stepSimulation(timeStep, maxSubSteps, fixedTimeStep);


	return;
}



//C[t[̕`
//y߂lFȂzyFȂz
void CBulletWorld::DrawFrame(void)
{
	_pDynamicsWorld->debugDrawWorld( );


	return;
}



//d͉x̐ݒ
//y߂lFȂzyFݒ肵d͉xz
void CBulletWorld::SetGravity(const btVector3 &gravity)
{
	_pDynamicsWorld->setGravity(gravity);


	return;
}



//[h̎擾
//y߂lF[h̃|C^zyFȂz
btDiscreteDynamicsWorld* CBulletWorld::GetWorld(void)
{
	return _pDynamicsWorld;
}



//Bullets(EnW)DirectXs(nW)ɕϊ
//y߂lFϊꂽDirectXs̃AhXzyFϊBulletsz
D3DXMATRIX CBulletWorld::ConvertTransform(const btTransform &matrix)
{
	D3DXMATRIX ret ;


	matrix.getOpenGLMatrix(&ret._11);


	return ret;
}



//DirectXs(nW)Bullets(EnW)ɕϊ
//y߂lFϊꂽBullets̃AhXzyFϊDirectXsz
btTransform CBulletWorld::ConvertTransform(const D3DXMATRIX &matrix)
{
	btTransform ret ;


	ret.setFromOpenGLMatrix(&matrix._11);


	return ret;
}



//BulletVector3DirectXVector3ɕϊ
//y߂lFϊꂽDirectXVector3zyFϊBulletVector3z
D3DXVECTOR3 CBulletWorld::ConvertVector3(const btVector3 &vec)
{
	return D3DXVECTOR3(vec.x( ), vec.y( ), vec.z( ));
}



//DirectXVector3BulletVector3ɕϊ
//y߂lFϊꂽBulletVector3zyFϊDirectXVector3z
btVector3 CBulletWorld::ConvertVector3(const D3DXVECTOR3 &vec)
{
	return btVector3(vec.x, vec.y, vec.z);
}

